/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.client.screen.components;

import java.util.function.BiConsumer;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.TextComponent;

public class GuiTextFieldBase
extends EditBox {
    private boolean suspended;
    private String valueDefault;
    private String valueOld;
    private BiConsumer<GuiTextFieldBase, String> postModification;

    public GuiTextFieldBase(Font fontRenderer, int x, int y, int width) {
        super(fontRenderer, x, y, width, 15, TextComponent.f_131282_);
        this.m_94199_(50);
        this.m_94153_(s -> {
            this.valueOld = this.m_94155_();
            return true;
        });
    }

    public void m_94144_(String textIn) {
        super.m_94144_(textIn);
        this.postModification(textIn);
    }

    public void postModification(String text) {
        if (!this.suspended && this.postModification != null) {
            this.suspended = true;
            this.postModification.accept(this, this.valueOld);
            this.suspended = false;
        }
    }

    public GuiTextFieldBase restrictToNumeric() {
        this.m_94153_(s -> {
            this.valueOld = this.m_94155_();
            if (s == null || s.isEmpty() || "-".equals(s)) {
                return true;
            }
            try {
                Integer.parseInt(s);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        });
        return this;
    }

    public int getInt() {
        try {
            return Integer.parseInt(this.m_94155_());
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public GuiTextFieldBase setDefaultInt(int defaultInt) {
        return this.setDefaultValue(Integer.toString(defaultInt));
    }

    public GuiTextFieldBase setDefaultValue(String defaultValue) {
        this.valueDefault = defaultValue;
        return this;
    }
}

